/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PRECO_ANALISE_MARGEM_META]    Script Date: 04/02/2014 12:39:26 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_ANALISE_MARGEM_META]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_ANALISE_MARGEM_META]
GO
GO
--Versao 2938
--exec P_EST_PROD_PRECO_ANALISE_MARGEM_META
CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_ANALISE_MARGEM_META] WITH ENCRYPTION AS  
BEGIN TRY
begin
	SET NOCOUNT ON;
    DECLARE @DT_REF DATE
    SET @DT_REF=GETDATE()
	DECLARE @STS_ALT_PRECO INT
	SET @STS_ALT_PRECO=1
	DECLARE @TIPO_CUSTO_ANALISE_EMPRESA INT
    DECLARE @ANALISA_CUSTO_PRODUTO_PRECIFICACAO INT
	
	CREATE TABLE #RsProdPrecoVigente(CD_EMP INT,
									 CD_GRUPO INT,
									 CD_PROD INT,
									 VLR_TABELA MONEY,
									 VLR_OFERTA MONEY,
									 CD_ALT_PRECO INT,
									 CD_ALT_PRECO_ANTERIOR INT)

    SET @ANALISA_CUSTO_PRODUTO_PRECIFICACAO = ISNULL(
                                (
                                    SELECT VALOR
                                    FROM PRC_EMP_CONFIG
                                    WHERE CD_CHAVE = 'ANALISA_CUSTO_PRODUTO_PRECIFICACAO'
                                ), 0);	
										 
	CREATE TABLE #RsGrupoPrecos (CD_EMP INT, 
								 CD_ALT_PRECO  INT,
								 CD_GRUPO INT,
								 FLAG_NAO_ARREDONDA INT)
	
	UPDATE
		EST_PROD_PRECO_ALT_PRC_FILIAL
	SET 
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_GRUPO = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO
	FROM            
		EST_PROD_PRECO_ALT 
		INNER JOIN EST_PROD_PRECO_ALT_PRC_FILIAL ON 
			EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP AND 
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO 
				
		INNER JOIN  EST_PRECIFICACAO_GRP_PRECO_FILIAL ON 
			EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP AND 
			EST_PROD_PRECO_ALT_PRC_FILIAL.CD_FILIAL = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL 
	WHERE
		EST_PROD_PRECO_ALT.APLICADO IN (0,2)
		AND EST_PROD_PRECO_ALT.CD_EMP=1
		AND ISNULL(EST_PROD_PRECO_ALT.DT_AGENDADA,'20000101') <=@DT_REF
		AND EST_PROD_PRECO_ALT.TP_ALT_PRECO=0;	

	INSERT INTO 
		#RsGrupoPrecos
	SELECT  
		DISTINCT EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP,
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO,
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_GRUPO,
		COALESCE(EST_PROD_PRECO_ALT.FLAG_NAO_ARREDONDA, 0)
	FROM            
		EST_PROD_PRECO_ALT 
		INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
			EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
		
		INNER JOIN EST_PROD_PRECO_ALT_PRC_FILIAL ON 
			EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP AND 
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO 
				
		INNER JOIN  EST_PRECIFICACAO_GRP_PRECO_FILIAL ON 
			EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP AND 
			EST_PROD_PRECO_ALT_PRC_FILIAL.CD_FILIAL = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL 
		INNER JOIN  EST_PRECIFICACAO_GRP_PRECO ON 
			EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP = EST_PRECIFICACAO_GRP_PRECO.CD_EMP AND 
			EST_PROD_PRECO_ALT_PRC_FILIAL.CD_GRUPO = EST_PRECIFICACAO_GRP_PRECO.CD_GRUPO 
	WHERE

		EST_PROD_PRECO_ALT.APLICADO IN (0,2)
		AND EST_PROD_PRECO_ALT.CD_EMP=1
		AND EST_PRECIFICACAO_GRP_PRECO.TIPO_GRUPO=0
		AND ISNULL(EST_PROD_PRECO_ALT.DT_AGENDADA,'20000101') <=@DT_REF
		AND EST_PROD_PRECO_ALT.TP_ALT_PRECO=0;		

--=============================================================================================	
	--Gravando o valor original 
	UPDATE 
		EST_PROD_PRECO_ALT_CPL
	SET
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA_ORIGINAL=EST_PROD_PRECO_ALT_CPL.VLR_TABELA
	FROM
		EST_PROD_PRECO_ALT_CPL INNER JOIN #RsGrupoPrecos GRP ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = GRP.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = GRP.CD_ALT_PRECO
	WHERE
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA_ORIGINAL IS NULL 
		OR EST_PROD_PRECO_ALT_CPL.VLR_TABELA_ORIGINAL=0

--=============================================================================================
	--Gravando o valor tabela vigente 
	INSERT INTO 
		#RsProdPrecoVigente
	SELECT
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP,
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO,
		EST_PROD_PRECO.CD_PROD,
		ROUND(ISNULL(AVG(EST_PROD_PRECO.VLR_TABELA),0),2) AS VLR_TABELA,
		ROUND(ISNULL(AVG(EST_PROD_PRECO.VLR_OFERTA),0),2) AS VLR_OFERTA,
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
		MAX(ISNULL(EST_PROD_PRECO.CD_ALT_PRECO,0)) AS CD_ALT_PRECO_ANTERIOR
	FROM
		EST_PROD_PRECO 
		INNER JOIN EST_PRECIFICACAO_GRP_PRECO_FILIAL ON
			EST_PROD_PRECO.CD_EMP = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP AND
			EST_PROD_PRECO.CD_FILIAL = EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_FILIAL
		INNER JOIN #RsGrupoPrecos GRP ON
			EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP = GRP.CD_EMP AND
			EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO = GRP.CD_GRUPO
		INNER JOIN EST_PROD_PRECO_ALT_CPL ON
			GRP.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND
			GRP.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO AND
			EST_PROD_PRECO.CD_PROD = EST_PROD_PRECO_ALT_CPL.CD_PROD
	WHERE EST_PROD_PRECO.CD_EMP = 1
	GROUP BY
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_EMP,
		EST_PRECIFICACAO_GRP_PRECO_FILIAL.CD_GRUPO,
		EST_PROD_PRECO.CD_PROD,
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO
	
	UPDATE 
		EST_PROD_PRECO_ALT_CPL
	SET
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA_VIGENTE=v.VLR_TABELA,
		EST_PROD_PRECO_ALT_CPL.VLR_OFERTA_VIGENTE=v.VLR_OFERTA,
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO_ANTERIOR = V.CD_ALT_PRECO_ANTERIOR
	FROM
		EST_PROD_PRECO_ALT_CPL 
		INNER JOIN #RsProdPrecoVigente v ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = v.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = V.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = V.CD_PROD 

--=============================================================================================

	--Gravando o valor original antes do arrdondamento
	UPDATE 
		EST_PROD_PRECO_ALT_CPL
	SET
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA=DBO.F_ARREDONDAR_PRECO_VENDA_TABELA(EST_PROD_PRECO_ALT_CPL.VLR_TABELA)
	FROM
		EST_PROD_PRECO_ALT_CPL 
		INNER JOIN #RsGrupoPrecos GRP ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = GRP.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = GRP.CD_ALT_PRECO	
		INNER JOIN EST_PROD ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD.CD_PROD 
	WHERE
		EST_PROD.CTR_PMC=0
		AND GRP.FLAG_NAO_ARREDONDA = 0
	
	IF @ANALISA_CUSTO_PRODUTO_PRECIFICACAO=0
		BEGIN
		PRINT 'Nao processa analise de custo produto'
		INSERT INTO EST_PROD_PRECO_ALT_CPL_LIB
			(CD_EMP,
			CD_ALT_PRECO,
			CD_PROD,
			CD_USU,
			DT_CAD)
			SELECT DISTINCT
				EST_PROD_PRECO_ALT_CPL.CD_EMP,
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
				EST_PROD_PRECO_ALT_CPL.CD_PROD,
				EST_PROD_PRECO_ALT.CD_USU,
				GETDATE()
			FROM            
				EST_PROD_PRECO_ALT 
				INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
				EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
				EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
				INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
				
			WHERE
				EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
				AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
				AND EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL					
			RETURN
		END
									 
	--=============================================================================================	
	--Liberando alteracao proveniente de programacao de precos
	--Oriundo de outro grupo de precos
	--EST_PROD_PRECO_ALT.PRECO_AGENDADO=1
	--Ou oriunda de alteracao de precos de oferta
		INSERT INTO EST_PROD_PRECO_ALT_CPL_LIB
			(CD_EMP,
			CD_ALT_PRECO,
			CD_PROD,
			CD_USU,
			DT_CAD)
			SELECT DISTINCT
				EST_PROD_PRECO_ALT_CPL.CD_EMP,
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
				EST_PROD_PRECO_ALT_CPL.CD_PROD,
				EST_PROD_PRECO_ALT.CD_USU,
				GETDATE()
			FROM            
				EST_PROD_PRECO_ALT 
				INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
				EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
				EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
				INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
				INNER JOIN EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO ON
				EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO.CD_EMP AND
				EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_AGENDADO_ANTIGO_APLICACAO.CD_ALT_PRECO_ORIGEM
			WHERE
				EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
				AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
				AND EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL	
			UNION ALL
			--Libera alteracao oferta
			SELECT DISTINCT
				EST_PROD_PRECO_ALT_CPL.CD_EMP,
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
				EST_PROD_PRECO_ALT_CPL.CD_PROD,
				EST_PROD_PRECO_ALT.CD_USU,
				GETDATE()
			FROM            
				EST_PROD_PRECO_ALT 
				INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
				EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
				EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
				LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
				EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
				EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
				EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
			WHERE
				EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
				AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
				AND EST_PROD_PRECO_ALT.TP_ALT_PRECO=1				
	--=============================================================================================	
		
    SET @TIPO_CUSTO_ANALISE_EMPRESA = ISNULL(
                                (
                                    SELECT VALOR
                                    FROM PRC_EMP_CONFIG
                                    WHERE CD_CHAVE = 'TIPO_CUSTO_ANALISE_EMPRESA'
                                ), 0);	
	
	/*
		0 - Ultimo custo
		1 - Custo medio
		2 - Custo gerencial
	*/	

	--Buscando dados de meta de margem do produto
	UPDATE
		EST_PROD_PRECO_ALT_CPL
	SET   
		EST_PROD_PRECO_ALT_CPL.TP_NIVEL_PERC = ISNULL(B.TP_NIVEL_PERC,0),
		EST_PROD_PRECO_ALT_CPL.PERC_MARGEM = ISNULL(B.PERC_MARGEM,0),
		EST_PROD_PRECO_ALT_CPL.DS_PERC_MARGEM = ISNULL(B.DS_PERC_MARGEM,'META MARGEM NAO DEFINIDA'),
		EST_PROD_PRECO_ALT_CPL.VLR_CUSTO = CASE WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 0 THEN --Ultimo custo
												ISNULL(EST_PROD.VLR_CUSTO_GRP,0)
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 1 THEN --Custo medio
												ISNULL(EST_PROD.VLR_CUSTO_MD_GRP,0)
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 2 THEN --Custo gerencial
												ISNULL(EST_PROD.VLR_CUSTO_GER_GRP,0)
											END,
		EST_PROD_PRECO_ALT_CPL.TP_CUSTO = @TIPO_CUSTO_ANALISE_EMPRESA,
		EST_PROD_PRECO_ALT_CPL.DS_TP_CUSTO=CASE WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 0 THEN --Ultimo custo
												'PARAMETRO ULTIMO CUSTO'
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 1 THEN --Custo medio
												'PARAMETRO CUSTO MEDIO'
											WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 2 THEN --Custo gerencial
												'PARAMETRO CUSTO GERENCIAL'
											END
	FROM            
		EST_PROD_PRECO_ALT 
		INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
		EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
		INNER JOIN #RsGrupoPrecos GRP ON
		EST_PROD_PRECO_ALT.CD_EMP = GRP.CD_EMP AND
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = GRP.CD_ALT_PRECO
		INNER JOIN EST_PROD ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
		LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
		OUTER APPLY UFD_EST_PROD_PRECIFICACAO_META_MARGEM(EST_PROD_PRECO_ALT_CPL.CD_EMP, GRP.CD_GRUPO, EST_PROD_PRECO_ALT_CPL.CD_PROD) B
	WHERE
		EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
		AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
		AND  EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL

	--Liberando o produto que nao possuir margem definida 
	--ou margem maior ou igual a definida no parametro 
	
	

  
	 
		SELECT DISTINCT
			EST_PROD_PRECO_ALT_CPL.CD_EMP,
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
			EST_PROD_PRECO_ALT_CPL.CD_PROD,
			EST_PROD_PRECO_ALT.CD_USU,
			GETDATE()		    DT_CAD,
			EST_PROD_PRECO_ALT_CPL.PERC_MARGEM,
			EST_PROD_PRECO_ALT_CPL.VLR_TABELA,
			EST_PROD_PRECO_ALT_CPL.VLR_CUSTO,
			CONVERT(tinyint,0) AS LIB_MARGEM
			into #TmpAlt
		FROM            
			EST_PROD_PRECO_ALT 
			INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
			EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
			INNER JOIN #RsGrupoPrecos GRP ON
			EST_PROD_PRECO_ALT.CD_EMP = GRP.CD_EMP AND
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = GRP.CD_ALT_PRECO
			INNER JOIN EST_PROD ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD.CD_PROD
			INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
		WHERE
			EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
			AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
			AND EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL
			and EST_PROD_PRECO_ALT.APLICADO IN (0,2)
			
			/*		
			AND EST_PROD_PRECO_ALT_CPL.VLR_CUSTO > 0  
			AND (EST_PROD_PRECO_ALT_CPL.PERC_MARGEM=0
				OR (((EST_PROD_PRECO_ALT_CPL.VLR_TABELA - EST_PROD_PRECO_ALT_CPL.VLR_CUSTO) / EST_PROD_PRECO_ALT_CPL.VLR_CUSTO) * 100)
					>= EST_PROD_PRECO_ALT_CPL.PERC_MARGEM)*/


    --DELETE from  #TmpAlt WHERE VLR_CUSTO=0;

    UPDATE #TmpAlt
    SET 
	  LIB_MARGEM  = CASE WHEN PERC_MARGEM=0 THEN 1
				    WHEN  (((VLR_TABELA - VLR_CUSTO) / VLR_CUSTO) * 100) >=PERC_MARGEM THEN 1
				    ELSE 0 END
    WHERE VLR_CUSTO>0;



    INSERT INTO EST_PROD_PRECO_ALT_CPL_LIB (CD_EMP, CD_ALT_PRECO, CD_PROD, CD_USU, DT_CAD)
    select CD_EMP, CD_ALT_PRECO, CD_PROD, CD_USU, DT_CAD
     from  #TmpAlt
    Where LIB_MARGEM=1

/**************************************************************************************************************/
	--bloqueandp o produto que nao possuir margem definida 
	--ou margem menor que a definida no parametro 
	INSERT INTO EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE
		(CD_EMP,
		CD_ALT_PRECO,
		CD_PROD,
		DT_CAD,
		DS_BLOQUEIO)
		SELECT
			EST_PROD_PRECO_ALT_CPL.CD_EMP,
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
			EST_PROD_PRECO_ALT_CPL.CD_PROD,
			GETDATE(),
			CASE WHEN EST_PROD_PRECO_ALT_CPL.VLR_CUSTO = 0 THEN
				CASE WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 0 THEN --Ultimo custo
					'ULTIMO CUSTO ZERADO'
				WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 1 THEN --Custo medio
					'CUSTO MEDIO ZERADO'
				WHEN @TIPO_CUSTO_ANALISE_EMPRESA = 2 THEN --Custo gerencial
					'CUSTO GERENCIAL ZERADO'
				END			
			ELSE
				'ERRO DE META DE MARGEM FORA DO ESPERADO'
			END 
		FROM            
			EST_PROD_PRECO_ALT 
			INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
			EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO
			
			INNER JOIN #TmpAlt xt ON  
			xt.CD_EMP		  = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
			xt.CD_PROD	  = EST_PROD_PRECO_ALT_CPL.CD_PROD AND 
			xt.CD_ALT_PRECO  = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO

			INNER JOIN #RsGrupoPrecos GRP ON
			EST_PROD_PRECO_ALT.CD_EMP = GRP.CD_EMP AND
			EST_PROD_PRECO_ALT.CD_ALT_PRECO = GRP.CD_ALT_PRECO  

			INNER JOIN EST_PROD ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD.CD_PROD
			INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_BLOQUEIO ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD
			LEFT OUTER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
			EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
			EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
			EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD
		WHERE
			EST_PROD_PRECO_ALT_CPL_BLOQUEIO.CD_PROD IS NULL
			AND EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD IS NULL
			AND EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD IS NULL
			and EST_PROD_PRECO_ALT.APLICADO IN (0,2)
			and xt.LIB_MARGEM=0			
					/*
			AND EST_PROD_PRECO_ALT_CPL.VLR_CUSTO > 0 
			OR (EST_PROD_PRECO_ALT_CPL.PERC_MARGEM > 0
				AND (((EST_PROD_PRECO_ALT_CPL.VLR_TABELA - EST_PROD_PRECO_ALT_CPL.VLR_CUSTO) / EST_PROD_PRECO_ALT_CPL.VLR_CUSTO) * 100)
					< EST_PROD_PRECO_ALT_CPL.PERC_MARGEM)
					*/

	DROP TABLE #RsGrupoPrecos;
	DROP TABLE #RsProdPrecoVigente;
end
END TRY
BEGIN CATCH
	declare @erro varchar (500) = ERROR_MESSAGE();
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
			RAISERROR(@erro, 16, 1);
END CATCH	
